/*
          
T3Series.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                          T3.4Bollinger Bands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 5
//----  
#property indicator_color1 Red
#property indicator_color2 Blue 
#property indicator_color3 Lime
#property indicator_color4 Blue
#property indicator_color5 Red
//----   
#property indicator_style1 4
#property indicator_style2 2
#property indicator_style3 4
#property indicator_style4 2
#property indicator_style5 4
//----    --------------------------------------------------------------------------------------------------+
extern int        Bands_Period = 100; //    J2Bollinger Bands
extern double Bands_Deviations = 2.0; //  
extern int           MA_method = 0;   //  
extern int           MA_Smooth = 20;  //    Moving Avereges
extern int        Bands_Smooth = 20;  //    Bollinger Bands
extern int    Smooth_Curvature = 100; //  ,    -100 ... +100,     ; 
extern int         Bands_Shift = 0;   // c     
extern int Input_Price_Customs = 0;   // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double UpperBuffer2  [];
double UpperBuffer1  [];
double T3MovingBuffer[];
double LowerBuffer1  [];
double LowerBuffer2  [];
double Series_buffer [];
//+------------------------------------------------------------------+ 
//----+   T3Series 
//----+   T3SeriesResize 
//----+   T3SeriesAlert 
//----+   T3_ErrDescr  
#include <T3Series.mqh> 
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| T3.4Bollinger Bands initialization function                      | 
//+------------------------------------------------------------------+  
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE); 
   SetIndexStyle(4,DRAW_LINE);
//---- 4       
   IndicatorBuffers(6);
   SetIndexBuffer(0,UpperBuffer2 );
   SetIndexBuffer(1,UpperBuffer1 );
   SetIndexBuffer(2,T3MovingBuffer);
   SetIndexBuffer(3,LowerBuffer1 );
   SetIndexBuffer(4,LowerBuffer2 );
   SetIndexBuffer(5,Series_buffer);
//----   ,      
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,0);
   SetIndexEmptyValue(3,0);
   SetIndexEmptyValue(4,0);
//----   ,        
   int drawbegin=100+Bands_Shift;
   SetIndexDrawBegin(0,drawbegin);
   SetIndexDrawBegin(1,drawbegin);
   SetIndexDrawBegin(2,drawbegin);
   SetIndexDrawBegin(3,drawbegin);
   SetIndexDrawBegin(4,drawbegin);
//----      
   SetIndexShift (0, Bands_Shift); 
   SetIndexShift (1, Bands_Shift); 
   SetIndexShift (2, Bands_Shift); 
   SetIndexShift (3, Bands_Shift); 
   SetIndexShift (4, Bands_Shift); 
//----        
   IndicatorShortName ("T3.4Bollinger Bands( Period="+Bands_Period+", Deviations="+Bands_Deviations+")"); 
   SetIndexLabel (0, "Upper2 Bands");
   SetIndexLabel (1, "Upper1 Bands"); 
   SetIndexLabel (3, "Lower1 Bands"); 
   SetIndexLabel (4, "Lower2 Bands"); 
   string Moving;
   switch(MA_method)
           {
            case  0: Moving= "T3SMA";break;
            case  1: Moving= "T3EMA";break;
            case  2: Moving="T3SSMA";break;
            case  3: Moving="T3LWMA";break;
            default: Moving="T3SMA";
           }
   SetIndexLabel (2, "Moving Avereges "+Moving+" ("+Bands_Period+")");
//----     
   IndicatorDigits(Digits);
//----+      T3Series, nT3.number=5(    T3Series)
   if (Bands_Smooth<=1){if (T3SeriesResize(1)!=1)return(-1);}else if (T3SeriesResize(5)!=5)return(-1);
//----       
   T3SeriesAlert(0,"MA_Smooth",MA_Smooth);
   T3SeriesAlert(0,"Bands_Period",Bands_Period);
   PriceSeriesAlert(Input_Price_Customs);
   if((MA_method<0)||(MA_method>3))
          Alert(" MA_method    0  3" + "    " 
                                                                +MA_method+ "   0");
//----     Bands_Period
   if(Bands_Period<1)Bands_Period=1; 
//----  
   return(0);
  }
//+------------------------------------------------------------------+  
//| T3.4Bollinger Bands iteration function                           | 
//+------------------------------------------------------------------+  
int start()
  {
//----       
if(Bars-1<=Bands_Period) return(0);
//----       
double deviation1,deviation2,Temp_Series,sum,midline,priceswing,Resalt;
//----+        
int reset,MaxBar,MaxBarBB,bar,kk,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  T3Series   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;MaxBar=Bars-1-Bands_Period;MaxBarBB=MaxBar-30-Bands_Period;
//----+              
for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
//----            
if (limit>MaxBar)
     {
      for(bar=limit;bar>=MaxBar;bar--)T3MovingBuffer[bar]=0;
      limit=MaxBar;
     }
//----+   Moving Avereges
for(bar=limit;bar>=0;bar--)
     {
      //----+    Moving Avereges
      Temp_Series=iMAOnArray(Series_buffer,0,Bands_Period,0,MA_method, bar);
      //----+   Moving Avereges
      //----+    T3Series   0.  nT3.Curvature  nT3.Length      (nT3.din=0)
      Resalt=T3Series(0,0,MaxBar,limit,Smooth_Curvature,MA_Smooth,Temp_Series,bar,reset);
      //----+       
      if(reset!=0)return(-1); 
      T3MovingBuffer[bar]=Resalt; 
     }     
//---- ר Bollinger Bands 
//----        
if (limit>MaxBarBB)
     {
      for(bar=limit;bar>=MaxBarBB;bar--)
       {
        UpperBuffer2[bar]=0;
        UpperBuffer1[bar]=0;
        LowerBuffer1[bar]=0;
        LowerBuffer2[bar]=0;
       }
      limit=MaxBarBB;
     }
for(bar=limit;bar>=0;bar--)
   {         
     sum=0.0;
     midline=T3MovingBuffer[bar];
     kk=bar+Bands_Period-1;
     while(kk>=bar)
      {
       priceswing=PriceSeries(Input_Price_Customs,kk)-midline;
       sum+=priceswing*priceswing;
       kk--;
      }
     deviation2=Bands_Deviations*MathSqrt(sum/Bands_Period);     
     deviation1=0.5*deviation2;
     if (Bands_Smooth>1)
        {
         //----+   T3  Bollinger Bands      
         //----+ ----------------------------------------------------------------------------------------+            
         //----+      T3Series   1, 2, 3, 4. 
         //----+  nT3.Length  t    (nT3.din=0)
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(1,0,MaxBarBB-1,limit,Smooth_Curvature,Bands_Smooth ,midline+deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer2[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+       
         Resalt=T3Series(2,0,MaxBarBB-1,limit,Smooth_Curvature,Bands_Smooth ,midline+deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer1[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(3,0,MaxBarBB-1,limit,Smooth_Curvature,Bands_Smooth ,midline-deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer1[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(4,0,MaxBarBB-1,limit,Smooth_Curvature,Bands_Smooth ,midline-deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer2[bar]=Resalt;         
         //----+ ----------------------------------------------------------------------------------------+ 
        }
      else 
        {
         //----+  Bollinger Bands  T3   
         UpperBuffer2[bar]=midline+deviation2;
         UpperBuffer1[bar]=midline+deviation1;
         LowerBuffer1[bar]=midline-deviation1;
         LowerBuffer2[bar]=midline-deviation2;
        }
      
   }
//----    
   return(0);
  }
//+---------------------------------------------------------------------------------+

